
function AISMN_BanditWait::OnEnter(%this, %data)
{
   %attacker = %data.attacker;
   %object   = GetThisObject(%data);
   if (isObject(%attacker) && IsAttackable(%attacker))
   {
      %data.performAction("attack", %attacker);
            
      // add the disaster alert if it has not yet been added
      // (this occurs when a bandit attacks combat unit before target)
      %disaster = $DisasterManager.getBanditAttack(%object);
      if (isObject(%disaster) == true)
      {
         alertSvrAddBanditAttack(%object, %attacker);
      }
   }
}

function AISMN_BanditWait::OnExit(%this, %data)
{
}

function AISMN_BanditWait::Update(%this,%data)
{
   %object = GetThisObject(%data);
   
   // remove disaster alert if attacker is dead
   %attacker = %data.attacker;
   if (isObject(%attacker) && !IsAlive(%attacker))
   {
      %disaster = $DisasterManager.getBanditAttack(%object);
      if (isObject(%disaster))
      {
         %message = slgGetUIString("id_bandit_attack_over");
         alertSvrRemoveObject($ALERT_BANDIT, %attacker, %message);
      }
   }
      
   if (%data.getCurrAction() $= "")
   {
      ReturnValue(%data, 0);
   }
   else
   {
      ReturnValue(%data, -1);
   }
}
